@echo off

REM **************************************************
REM
REM PC Week database benchmark data generation script
REM   -- Timothy Dyck, PC Week Labs
REM
REM **************************************************

REM **************************************************
REM intro banner
REM **************************************************

echo.
echo Start of PC Week database benchmark data generation run.
echo.
echo Small version of data generator, 1/100 of actual size
echo 12 tables, 1,411,100 total rows of data, on-disk size is 177,096,404 bytes
echo.
echo. | date
echo. | time
echo.

REM **************************************************
REM generate data
REM **************************************************

echo Generating "uniques" table, base structure "uniques", number of rows = 200,000
as3apgen -un -r -n 200000
ren asap.uni uniques.dat
ren asap.rpt uniques_datagen-output.txt
echo.

echo Generating "hundred" table, base structure "hundred", number of rows = 200,000
as3apgen -hu -r -n 200000
ren asap.hun hundred.dat
ren asap.rpt hundred_datagen-output.txt
echo.

echo Generating "tenpct" table, base structure "tenpct", number of rows = 200,000
as3apgen -te -r -n 200000
ren asap.ten tenpct.dat
ren asap.rpt tenpct_datagen-output.txt
echo.

echo Generating "updates" table, base structure "updates", number of rows = 200,000
as3apgen -up -r -n 200000
ren asap.upd updates.dat
ren asap.rpt updates_datagen-output.txt
echo.

echo Generating "tenthou" table, base structure "tenpct", number of rows = 100
as3apgen -te -r -n 100
ren asap.ten tenthou.dat
ren asap.rpt tenthou_datagen-output.txt
echo.

echo Generating "hunthou" table, base structure "hundred", number of rows = 1,000
as3apgen -hu -r -n 1000
ren asap.hun hunthou.dat
ren asap.rpt hunthou_datagen-output.txt
echo.

echo Generating "twomill" table, base structure "updates", number of rows = 20,000
as3apgen -up -r -n 20000
ren asap.upd twomill.dat
ren asap.rpt twomill_datagen-output.txt
echo.

echo Generating "threemill" table, base structure "tenpct", number of rows = 30,000
as3apgen -te -r -n 30000
ren asap.ten threemill.dat
ren asap.rpt threemill_datagen-output.txt
echo.

echo Generating "fourmill" table, base structure "tenpct", number of rows = 40,000
as3apgen -te -r -n 40000
ren asap.ten fourmill.dat
ren asap.rpt fourmill_datagen-output.txt
echo.

echo Generating "fivemill" table, base structure "hundred", number of rows = 50,000
as3apgen -hu -r -n 50000
ren asap.hun fivemill.dat
ren asap.rpt fivemill_datagen-output.txt
echo.

echo Generating "sevmill" table, base structure "uniques", number of rows = 70,000
as3apgen -un -r -n 70000
ren asap.uni sevmill.dat
ren asap.rpt sevmill_datagen-output.txt
echo.

echo Generating "fourtymill" table, base structure "uniques", number of rows = 400,000
as3apgen -un -r -n 400000
ren asap.uni fourtymill.dat
ren asap.rpt fourtymill_datagen-output.txt
echo.

REM **************************************************
REM reset attributes on data files
REM **************************************************

attrib -r *.dat
attrib -r *.txt

REM **************************************************
REM end banner
REM **************************************************

echo End of data generation run.
echo.
echo. | date
echo. | time
